#include	"..\..\DLL\d_iNES.h"
#include	"..\..\Hardware\h_Latch.h"

namespace {
#define cpuA14   !(Latch::addr &0x001)
#define mirrorH !!(Latch::addr &0x002)
#define nrom    !!(Latch::addr &0x100)
#define chr       (nrom? (Latch::addr >>1 &0xC | Latch::addr >>5 &0x3): (Latch::addr >>1 &0x8 | Latch::addr >>5 &0x7))
#define prg       (Latch::addr >>2 &0x07)

void	sync (void) {
	EMU->SetPRG_ROM16(0x8, prg &~(cpuA14*nrom));
	EMU->SetPRG_ROM16(0xC, prg |  cpuA14*nrom  |7*!nrom);
	
	iNES_SetCHR_Auto8(0x0, chr);
	
	if (mirrorH)
		EMU->Mirror_H();
	else
		EMU->Mirror_V();
}


BOOL	MAPINT	load (void) {
	iNES_SetSRAM();
	Latch::load(sync, NULL);
	return TRUE;
}

uint16_t mapperNum =739;
} // namespace


MapperInfo MapperInfo_739 = {
	&mapperNum,
	_T("HC004 LV103"),
	COMPAT_FULL,
	load,
	Latch::resetHard,
	NULL,
	NULL,
	NULL,
	Latch::saveLoad_A,
	NULL,
	NULL
};